/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

public class TMyStreamFile
extends TMyPrebufferedFile {
    private TStreamProvider StreamProvider;
    private int streamPos;
    private InputStream is;
    private int progress = -1;
    private boolean AbortUnpacking;
    private boolean bSupportAbort;

    public TMyStreamFile(String string, TStreamProvider tStreamProvider, boolean bl) throws Exception {
        super(string, true);
        this.StreamProvider = tStreamProvider;
        this.bSupportAbort = bl;
        hxshared.gc();
        try {
            this.is = tStreamProvider.GetStream();
        }
        catch (Exception exception) {
            tStreamProvider.Free();
            throw new Exception("");
        }
        this.streamPos = 0;
        this.Length = this.is.available();
        if (this.Length < 2) {
            try {
                int n;
                do {
                    if ((n = this.is.read(this.buffer, 0, this.buffer.length)) < 0) {
                        n = 0;
                    }
                    this.Length += n;
                } while (n > 0);
                this.streamPos = this.Length;
            }
            catch (Exception exception) {
                tStreamProvider.FreeStream(this.is);
                tStreamProvider.Free();
                throw new Exception("");
            }
        }
    }

    public void Close() {
        this.StreamProvider.FreeStream(this.is);
        this.StreamProvider.Free();
        this.buffer = null;
    }

    public void AbortReadOperation() {
        this.AbortUnpacking = true;
    }

    private final boolean SeekStreamToOffset(int n) throws Exception {
        this.AbortUnpacking = false;
        if (this.streamPos > n) {
            this.StreamProvider.FreeStream(this.is);
            this.is = this.StreamProvider.GetStream();
            this.streamPos = 0;
        }
        while (this.streamPos < n) {
            int n2;
            if (this.bSupportAbort && this.AbortUnpacking) {
                this.AbortUnpacking = false;
                this.progress = -1;
                return false;
            }
            if (this.bSupportAbort) {
                this.progress = this.streamPos * 70 / n;
            }
            this.streamPos += this.is.read(this.buffer, 0, (n2 = n - this.streamPos) < this.buffer.length ? n2 : this.buffer.length);
        }
        this.AbortUnpacking = false;
        this.progress = -1;
        return true;
    }

    protected final boolean PreBuffer() {
        int n;
        int n2;
        int n3;
        int n4 = this.FilePos - this.buffer.length / 2;
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = this.Length - n4) > this.buffer.length) {
            n3 = this.buffer.length;
        }
        int n5 = 0;
        int n6 = n3;
        if (n4 >= this.bufferOffset && (n2 = this.bufferSize - (n = n4 - this.bufferOffset)) > 0) {
            System.arraycopy(this.buffer, n, this.buffer, 0, n2);
            n5 = n2;
            n6 = n3 - n2;
        }
        this.bufferSize = n3;
        this.bufferOffset = n4;
        if (n6 > 0) {
            try {
                if (!this.SeekStreamToOffset(this.bufferOffset + n5)) {
                    this.InvalidateBuffer();
                    return false;
                }
                this.streamPos += n6;
                while (n6 > 0) {
                    n = this.is.read(this.buffer, n5, n6);
                    n5 += n;
                    n6 -= n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static interface TStreamProvider {
        public InputStream GetStream() throws Exception;

        public void FreeStream(InputStream var1);

        public void Free();
    }
}

