/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

public class TCPMan {
    private static char[][] UniEncode = new char[2][128];
    public static byte[][] CodePageEx = new byte[4][128];
    public static byte[] NoAccentsTable = new byte[128];

    TCPMan() throws Exception {
        int n;
        InputStream inputStream = Common.GetResourceStream("res/cp.bin");
        byte[] byArray = new byte[256];
        for (n = 0; n < 2; ++n) {
            inputStream.read(byArray, 0, 256);
            int n2 = 0;
            for (int i = 0; i < 128; ++i) {
                TCPMan.UniEncode[n][i] = (char)((byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8));
                n2 += 2;
            }
        }
        for (n = 0; n < 4; ++n) {
            inputStream.read(CodePageEx[n], 0, 128);
        }
        inputStream.read(NoAccentsTable, 0, 128);
        inputStream.close();
    }

    public String Encode(int n, boolean bl, byte by, byte[] byArray, int n2, int n3, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n4 = 0;
        int n5 = n2 + n3;
        byte[] byArray2 = null;
        if (by > 0) {
            byArray2 = CodePageEx[by - 1];
        }
        char[] cArray = UniEncode[n];
        for (int i = n2; i != n5; ++i) {
            int n6 = byArray[i] & 0xFF;
            if (by > 0 && n6 >= 128) {
                n6 = byArray2[n6 - 128] & 0xFF;
            }
            if (bl && n6 >= 128) {
                n6 = NoAccentsTable[n6 - 128] & 0xFF;
            }
            if (n6 <= 127) {
                if (n6 <= 32) {
                    stringBuffer.append(' ');
                } else {
                    if (n != 0 && n6 >= 97 && n6 <= 122) {
                        n6 -= 32;
                    }
                    stringBuffer.append((char)n6);
                }
            } else {
                stringBuffer.append(cArray[n6 - 128]);
            }
            ++n4;
        }
        if (bl2) {
            stringBuffer.reverse();
        }
        return stringBuffer.toString();
    }

    public String UnicodeUpperCase(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c <= '\u0080') continue;
            for (int j = 0; j < 128; ++j) {
                if (c != UniEncode[0][j]) continue;
                stringBuffer.setCharAt(i, UniEncode[1][j]);
            }
        }
        return stringBuffer.toString();
    }

    public String UniDecode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                stringBuffer.append(c);
                continue;
            }
            boolean bl = false;
            for (int j = 0; j < 128 && !bl; ++j) {
                if (UniEncode[0][j] != c) continue;
                stringBuffer.append((char)(j + 128));
                bl = true;
            }
            if (bl) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static final boolean isPNKTchar(byte by) {
        return by == 32 || by == 34 || by == 44 || by == 46 || by == 58 || by == 59 || by == 63;
    }

    public static final byte[] ReverceR2L(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = n + n2 - 1;
        int n4 = 0;
        while (n3 >= 0) {
            if (byArray[n3] < 0 || TCPMan.isPNKTchar(byArray[n3])) {
                byArray2[n4++] = byArray[n3--];
                continue;
            }
            int n5 = 0;
            while (n3 - n5 >= 0 && byArray[n3 - n5] > 0) {
                ++n5;
            }
            n3 -= n5;
            while (n5 > 0 && TCPMan.isPNKTchar(byArray[n3 + 1])) {
                --n5;
                ++n3;
            }
            for (int i = 1; i <= n5; ++i) {
                byArray2[n4++] = byArray[n3 + i];
            }
        }
        return byArray2;
    }
}

