/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class TMyMMCFile
extends TMyFile {
    private static Vector OpenedFiles = new Vector();
    private int FilePos = 0;
    private TRecord FileHeader;
    private TRecord FAT = null;
    private TRecord CurrentRecord;
    private byte[] FATData;
    private int CurrentRecordOffset;
    private static int BUFSIZE = 1024;
    private byte[] RecBuf = new byte[BUFSIZE];
    private boolean modified;
    private boolean HeaderModified;
    private boolean FATModified;

    private static TRecord GetFileHeader(String string) {
        string = string.toUpperCase();
        TRecord tRecord = new TRecord();
        tRecord.rs = null;
        RecordEnumeration recordEnumeration = null;
        try {
            tRecord.rs = RecordStore.openRecordStore((String)"FileList", (boolean)false);
            recordEnumeration = tRecord.rs.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                tRecord.Id = recordEnumeration.nextRecordId();
                byte[] byArray = tRecord.rs.getRecord(tRecord.Id);
                if (byArray == null || byArray.length != 43 || byArray[0] > 32 || !string.equals(hxshared.ByteArrayToString(byArray, 1, byArray[0]))) continue;
                recordEnumeration.destroy();
                return tRecord;
            }
            recordEnumeration.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tRecord.rs != null) {
            try {
                tRecord.rs.closeRecordStore();
                tRecord.rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (recordEnumeration != null) {
            try {
                recordEnumeration.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private TRecord CreateNewRecord() {
        TRecord tRecord = new TRecord();
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("FileList") || stringArray[i].equals("crash")) continue;
                tRecord.rs = null;
                try {
                    tRecord.rs = RecordStore.openRecordStore((String)stringArray[i], (boolean)false);
                    if (tRecord.rs.getNumRecords() >= 50) {
                        throw new Exception();
                    }
                    byte[] byArray = new byte[1];
                    tRecord.Id = tRecord.rs.addRecord(byArray, 0, 1);
                    tRecord.RecordStoreNameId = Short.parseShort(stringArray[i]);
                    return tRecord;
                }
                catch (Exception exception) {
                    try {
                        if (tRecord.rs == null) continue;
                        tRecord.rs.closeRecordStore();
                        continue;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        tRecord.rs = null;
        while (tRecord.rs == null) {
            tRecord.RecordStoreNameId = (short)(System.currentTimeMillis() % 32767L);
            String string = String.valueOf(tRecord.RecordStoreNameId);
            try {
                tRecord.rs = RecordStore.openRecordStore((String)string, (boolean)false);
                tRecord.rs.closeRecordStore();
                tRecord.rs = null;
            }
            catch (Exception exception) {
                try {
                    tRecord.rs = RecordStore.openRecordStore((String)string, (boolean)true);
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                    tRecord.rs = null;
                    return null;
                }
            }
        }
        try {
            byte[] byArray = new byte[1];
            tRecord.Id = tRecord.rs.addRecord(byArray, 0, 1);
        }
        catch (Exception exception) {
            try {
                tRecord.rs.closeRecordStore();
                tRecord.rs = null;
            }
            catch (Exception exception4) {
                exception4.printStackTrace();
            }
            return null;
        }
        return tRecord;
    }

    private void UpdateFileHeader() throws Exception {
        byte[] byArray = new byte[43];
        int n = Math.min(32, this.fileName.length());
        byArray[0] = (byte)n;
        System.arraycopy(hxshared.StringToByteArray(this.fileName), 0, byArray, 1, n);
        byArray[33] = (byte)(this.FAT.RecordStoreNameId >> 8);
        byArray[34] = (byte)(this.FAT.RecordStoreNameId % 256);
        byArray[35] = (byte)(this.FAT.Id >> 24);
        byArray[36] = (byte)(this.FAT.Id >> 16 & 0xFF);
        byArray[37] = (byte)(this.FAT.Id >> 8 & 0xFF);
        byArray[38] = (byte)(this.FAT.Id & 0xFF);
        byArray[39] = (byte)(this.Length >> 24);
        byArray[40] = (byte)(this.Length >> 16 & 0xFF);
        byArray[41] = (byte)(this.Length >> 8 & 0xFF);
        byArray[42] = (byte)(this.Length & 0xFF);
        this.FileHeader.rs.setRecord(this.FileHeader.Id, byArray, 0, 43);
    }

    private TMyMMCFile(String string) throws Exception {
        super(string.toUpperCase());
        this.FileHeader = TMyMMCFile.GetFileHeader(this.fileName);
        if (this.FileHeader != null) {
            try {
                byte[] byArray = this.FileHeader.rs.getRecord(this.FileHeader.Id);
                if (byArray == null || byArray.length != 43) {
                    throw new Exception();
                }
                this.FAT = new TRecord();
                this.FAT.RecordStoreNameId = (short)(((byArray[33] & 0xFF) << 8) + (byArray[34] & 0xFF));
                this.FAT.Id = ((byArray[35] & 0xFF) << 24) + ((byArray[36] & 0xFF) << 16) + ((byArray[37] & 0xFF) << 8) + (byArray[38] & 0xFF);
                this.Length = ((byArray[39] & 0xFF) << 24) + ((byArray[40] & 0xFF) << 16) + ((byArray[41] & 0xFF) << 8) + (byArray[42] & 0xFF);
                this.FAT.rs = RecordStore.openRecordStore((String)String.valueOf(this.FAT.RecordStoreNameId), (boolean)false);
                this.FATData = this.FAT.rs.getRecord(this.FAT.Id);
                if (this.FATData == null || this.FATData.length == 1) {
                    this.FATData = new byte[0];
                }
                if ((this.Length + 1023) / 1024 * 6 != this.FATData.length) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                try {
                    if (this.FAT != null) {
                        this.FAT.rs.closeRecordStore();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (this.FileHeader != null) {
                        this.FileHeader.rs.closeRecordStore();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
        if (this.FileHeader == null) {
            this.FileHeader = new TRecord();
            this.FileHeader.Id = -1;
            this.FileHeader.rs = null;
            try {
                this.FileHeader.rs = RecordStore.openRecordStore((String)"FileList", (boolean)true);
                if (this.FileHeader.rs.getSizeAvailable() < 2000) {
                    this.FileHeader.rs.closeRecordStore();
                    this.FileHeader.rs = null;
                    throw new Exception("LowSpace");
                }
                this.FileHeader.Id = this.FileHeader.rs.addRecord(new byte[1], 0, 1);
                this.Length = 0;
                this.FAT = this.CreateNewRecord();
                this.FATData = new byte[0];
                this.UpdateFileHeader();
            }
            catch (Exception exception) {
                try {
                    if (this.FileHeader != null) {
                        if (this.FileHeader.Id != -1) {
                            this.FileHeader.rs.deleteRecord(this.FileHeader.Id);
                        }
                        this.FileHeader.rs.closeRecordStore();
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                try {
                    if (this.FAT != null) {
                        this.FAT.rs.deleteRecord(this.FAT.Id);
                        this.FAT.rs.closeRecordStore();
                    }
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                throw new IOException("No free space to create file " + this.fileName + ":" + exception.getMessage() + exception.toString());
            }
        }
        this.CurrentRecord = new TRecord();
        this.CurrentRecord.rs = null;
        this.modified = false;
        this.FATModified = false;
        this.HeaderModified = false;
        OpenedFiles.addElement(this);
    }

    public static final TMyMMCFile Open(String string) throws Exception {
        return new TMyMMCFile(string);
    }

    private void Update() {
        try {
            this.CurrentRecord.rs.setRecord(this.CurrentRecord.Id, this.RecBuf, 0, Math.max(1, Math.min(1024, this.Length - this.CurrentRecordOffset)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.modified = false;
    }

    private void UpdateFAT() {
        try {
            this.FAT.rs.setRecord(this.FAT.Id, this.FATData, 0, (this.Length + 1023) / 1024 * 6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.FATModified = false;
    }

    public void Close() {
        if (this.modified) {
            this.Update();
        }
        try {
            if (this.HeaderModified) {
                this.UpdateFileHeader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.FATModified) {
            this.UpdateFAT();
        }
        try {
            if (this.CurrentRecord.rs != null) {
                this.CurrentRecord.rs.closeRecordStore();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.FAT.rs.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.FileHeader.rs.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fileName = null;
        this.FileHeader.rs = null;
        this.FileHeader = null;
        this.FAT.rs = null;
        this.FAT = null;
        this.CurrentRecord.rs = null;
        this.CurrentRecord = null;
        this.RecBuf = null;
        OpenedFiles.removeElement(this);
    }

    private void PreBuffer() {
        if (this.modified) {
            this.Update();
        }
        try {
            if (this.CurrentRecord.rs != null) {
                this.CurrentRecord.rs.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.CurrentRecordOffset = this.FilePos / 1024 * 1024;
        this.CurrentRecord.rs = null;
        if (this.CurrentRecordOffset == this.Length) {
            return;
        }
        int n = this.FilePos / 1024 * 6;
        try {
            if (this.FATData.length < n + 6) {
                throw new Exception();
            }
            this.CurrentRecord.RecordStoreNameId = (short)(((this.FATData[n] & 0xFF) << 8) + (this.FATData[n + 1] & 0xFF));
            this.CurrentRecord.Id = ((this.FATData[n + 2] & 0xFF) << 24) + ((this.FATData[n + 2 + 1] & 0xFF) << 16) + ((this.FATData[n + 2 + 2] & 0xFF) << 8) + (this.FATData[n + 2 + 3] & 0xFF);
            this.CurrentRecord.rs = RecordStore.openRecordStore((String)String.valueOf(this.CurrentRecord.RecordStoreNameId), (boolean)false);
            byte[] byArray = this.CurrentRecord.rs.getRecord(this.CurrentRecord.Id);
            System.arraycopy(byArray, 0, this.RecBuf, 0, byArray.length);
        }
        catch (Exception exception) {
            this.CurrentRecord.rs = null;
            this.RecBuf = new byte[1024];
            for (int i = 0; i < 1024; ++i) {
                this.RecBuf[i] = 0;
            }
        }
    }

    public int Read(byte[] byArray, int n, int n2) {
        if (this.CurrentRecord.rs == null || this.FilePos < this.CurrentRecordOffset || this.FilePos >= this.CurrentRecordOffset + 1024) {
            this.PreBuffer();
        }
        if (this.FilePos + n2 > this.Length && (n2 = this.Length - this.FilePos) <= 0) {
            return 0;
        }
        int n3 = Math.min(n2, this.CurrentRecordOffset + 1024 - this.FilePos);
        System.arraycopy(this.RecBuf, this.FilePos - this.CurrentRecordOffset, byArray, n, n3);
        this.FilePos += n3;
        if (n2 > n3) {
            return n3 + this.Read(byArray, n + n3, n2 - n3);
        }
        return n3;
    }

    public boolean ReadSingleByte(byte[] byArray, int n) {
        if (this.FilePos > this.Length - 1) {
            return false;
        }
        if (this.CurrentRecord.rs == null || this.FilePos < this.CurrentRecordOffset || this.FilePos >= this.CurrentRecordOffset + 1024) {
            this.PreBuffer();
        }
        byArray[n] = this.RecBuf[this.FilePos - this.CurrentRecordOffset];
        ++this.FilePos;
        return true;
    }

    public boolean ReadSingleByteReverse(byte[] byArray, int n) {
        if (this.FilePos == 0) {
            return false;
        }
        if (this.CurrentRecord.rs == null || this.FilePos < this.CurrentRecordOffset || this.FilePos >= this.CurrentRecordOffset + 1024) {
            this.PreBuffer();
        }
        byArray[n] = this.RecBuf[this.FilePos - this.CurrentRecordOffset];
        --this.FilePos;
        return true;
    }

    public byte ReadByte() throws IOException {
        if (this.FilePos > this.Length - 1) {
            return 0;
        }
        if (this.CurrentRecord.rs == null || this.FilePos < this.CurrentRecordOffset || this.FilePos >= this.CurrentRecordOffset + 1024) {
            this.PreBuffer();
        }
        ++this.FilePos;
        return this.RecBuf[this.FilePos - this.CurrentRecordOffset - 1];
    }

    public int Write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.CurrentRecord.rs == null || this.FilePos < this.CurrentRecordOffset || this.FilePos >= this.CurrentRecordOffset + 1024) {
            this.PreBuffer();
        }
        if (this.CurrentRecord.rs == null) {
            this.CurrentRecord = this.CreateNewRecord();
            this.FATModified = true;
            n3 = this.FilePos / 1024 * 6;
            if (this.FATData.length < n3 + 6) {
                byte[] byArray2 = new byte[Math.max(600, this.FATData.length * 3 / 2)];
                System.arraycopy(this.FATData, 0, byArray2, 0, this.FATData.length);
                this.FATData = byArray2;
            }
            this.FATData[n3] = (byte)(this.CurrentRecord.RecordStoreNameId >> 8);
            this.FATData[n3 + 1] = (byte)(this.CurrentRecord.RecordStoreNameId & 0xFF);
            this.FATData[n3 + 2] = (byte)(this.CurrentRecord.Id >> 24 & 0xFF);
            this.FATData[n3 + 2 + 1] = (byte)(this.CurrentRecord.Id >> 16 & 0xFF);
            this.FATData[n3 + 2 + 2] = (byte)(this.CurrentRecord.Id >> 8 & 0xFF);
            this.FATData[n3 + 2 + 3] = (byte)(this.CurrentRecord.Id & 0xFF);
        }
        n3 = Math.min(n2, this.CurrentRecordOffset + 1024 - this.FilePos);
        System.arraycopy(byArray, n, this.RecBuf, this.FilePos - this.CurrentRecordOffset, n3);
        this.FilePos += n3;
        if (this.FilePos > this.Length) {
            this.Length = this.FilePos;
            this.HeaderModified = true;
        }
        this.modified = true;
        if (n3 < n2) {
            return n3 + this.Write(byArray, n + n3, n2 - n3);
        }
        return n2;
    }

    static int SpaceAvailable() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"sizetest", (boolean)true);
            int n = recordStore.getSizeAvailable();
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"sizetest");
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int FilePos() {
        return this.FilePos;
    }

    public void Seek(int n) {
        if (n > this.Length) {
            n = this.Length;
        }
        this.FilePos = n < 0 ? 0 : n;
    }

    static boolean CreateCrashRecord() throws Exception {
        try {
            if (Common.ignoreCrashRecord) {
                throw new Exception("");
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"crash", (boolean)false);
            recordStore.closeRecordStore();
            return true;
        }
        catch (Exception exception) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"crash", (boolean)true);
                recordStore.closeRecordStore();
            }
            catch (Exception exception2) {
                TMyMMCFile.EraseAll();
                throw new Exception("Unable to access RMS - possibly no free space left. Initialising to default state. Please restart midlet.");
            }
            return false;
        }
    }

    static void DeleteCrashRecord() {
        try {
            RecordStore.deleteRecordStore((String)"crash");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void EraseAll() {
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                RecordStore.deleteRecordStore((String)stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class TRecord {
        public RecordStore rs;
        public short RecordStoreNameId;
        public int Id;

        private TRecord() {
        }
    }
}

