/*
 * Decompiled with CFR 0.152.
 */
import com.motorola.funlight.FunLight;
import com.motorola.funlight.Region;
import com.motorola.multimedia.Lighting;
import com.nokia.mid.ui.DeviceControl;
import com.samsung.util.LCDLight;
import com.siemens.mp.game.Light;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import mmpp.media.BackLight;

public class TLightController
extends TimerTask {
    private byte method;
    private static TLightController inst = null;
    private Region r1;
    private Region r2;
    private Region r3;
    Timer funLightsTimer;
    private static MIDlet midlet;
    private static int curBrightness;

    private final void ApplyState() {
        switch (this.method) {
            case 1: {
                if (curBrightness > 0) {
                    Light.setLightOn();
                    break;
                }
                Light.setLightOff();
                break;
            }
            case 2: {
                DeviceControl.setLights((int)0, (int)(curBrightness * 100 / 255));
                break;
            }
            case 3: {
                if (curBrightness > 0) {
                    Lighting.backlightOn();
                    break;
                }
                Lighting.backlightOff();
                break;
            }
            case 4: {
                int n = curBrightness + (curBrightness << 8) + (curBrightness << 16);
                FunLight.getRegion((int)1).setColor(n);
                this.r1.setColor(0);
                this.r2.setColor(0);
                this.r3.setColor(0);
                break;
            }
            case 5: {
                if (curBrightness > 0) {
                    LCDLight.on((int)0xFFFFFFF);
                    break;
                }
                LCDLight.off();
                break;
            }
            case 6: {
                if (curBrightness > 0) {
                    BackLight.on((int)0xFFFFFFF);
                    break;
                }
                BackLight.off();
                break;
            }
            case 7: {
                if (curBrightness > 0) {
                    Display.getDisplay((MIDlet)midlet).flashBacklight(Integer.MAX_VALUE);
                    break;
                }
                Display.getDisplay((MIDlet)midlet).flashBacklight(0);
            }
        }
    }

    public final void run() {
        this.ApplyState();
    }

    private TLightController(MIDlet mIDlet) {
        block16: {
            curBrightness = -1;
            midlet = mIDlet;
            this.method = 0;
            try {
                Class.forName("com.siemens.mp.game.Light");
                this.method = 1;
            }
            catch (Exception exception) {
                try {
                    Class.forName("com.nokia.mid.ui.DeviceControl");
                    this.method = (byte)2;
                }
                catch (Exception exception2) {
                    try {
                        Class.forName("com.motorola.funlight.FunLight");
                        this.method = (byte)4;
                    }
                    catch (Exception exception3) {
                        try {
                            Class.forName("com.motorola.multimedia.Lighting");
                            this.method = (byte)3;
                        }
                        catch (Exception exception4) {
                            try {
                                Class.forName("com.samsung.util.LCDLight");
                                if (!LCDLight.isSupported()) {
                                    throw new Exception();
                                }
                                this.method = (byte)5;
                            }
                            catch (Exception exception5) {
                                try {
                                    Class.forName("mmpp.media.BackLight");
                                    this.method = (byte)6;
                                }
                                catch (Exception exception6) {
                                    if (System.getProperty("microedition.profiles").indexOf("2.0") <= 0) break block16;
                                    this.method = (byte)7;
                                }
                            }
                        }
                    }
                }
            }
        }
        String string = hxshared.GetConfigProperty("LIGHTCONTROL");
        if (string != null) {
            this.method = Byte.parseByte(string);
        }
        if (this.method == 4) {
            FunLight.getControl();
            this.r1 = FunLight.getRegion((int)2);
            this.r2 = FunLight.getRegion((int)3);
            this.r3 = FunLight.getRegion((int)4);
            this.funLightsTimer = new Timer();
            this.funLightsTimer.scheduleAtFixedRate((TimerTask)this, 0L, 100L);
        } else {
            this.funLightsTimer = new Timer();
            this.funLightsTimer.scheduleAtFixedRate((TimerTask)this, 0L, 3000L);
        }
        this.ApplyState();
    }

    public static TLightController GetInstance(MIDlet mIDlet) {
        if (inst == null) {
            inst = new TLightController(mIDlet);
        }
        return inst;
    }

    public boolean CanControl() {
        return this.method != 0;
    }

    public boolean CanControlBrightness() {
        return this.method == 2 || this.method == 4;
    }

    public void SetBrightness(int n) {
        if (curBrightness == n) {
            return;
        }
        curBrightness = n;
        this.ApplyState();
    }
}

